---
--- VX_sp_FillCaseBuffer
---  
--- Formerly known as SP_NEW 
---  
---Modified 2010-03-24: ReAdded the Location='Server' filter 
---Modified 2010-07-02: Enabled the pronto option :  Use Do Not Call list
---Modified 2010-12-01: Performance using tempdb
---Modified 2011-07-20: Added dialing mode. Renamed
---Modified 2011-11-18: Support for TimeSlot Counters
---Modified 2011-12-15: Weight applies to Callbacks
---Modified 2012-01-12: RoleSets
---Modified 2012-07-09: Change the nature of ResTimeSlot
---Modified 2012-09-18: Exclude assigned cases when in Role mode
---Modified 2012-11-02: Fix for Half opened
---Modified 2013-04-22: Fix for Half opened (2)
---Modified 2013-07-11: Fix for blocking of extraction in ServNo
---Modified 2013-09-13: Added Tracing
---Modified 2013-10-28: Added Tracing info; Performance modification for #excludedRespondent
---Modified 2014-01-28: Quota by question support for Half Open
---Modified 2014-02-24: US1948 Filter numbers with Do Not Call, clean after 3 years
---Modified 2014-07-02: US2333 Filter empty phoneNumber feature, inject PhoneNumber from alias feature
---Modified 2014-07-25: Fix for Half opened stratum count
---Modified 2014-08-06: Fix for Half opened recursion
---Modified 2014-08-27: Performance correction for DNC using #excludedRespondent 
---Modified 2014-10-06: Fix DateTime Where clause format for international support ( ISO 8601 )
---Modified 2014-10-07: US2858 Fill BufferNew should leave detail traces of the Distribution
---Modified 2014-10-15: Fix Distribution for Weighted Priority
---Modified 2015-12-23: add ManualFilter option for TCPA compliance
---Modified 2016-04-27: trigger VX_sp_ReassignHardCallback
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_FillCaseBuffer]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_FillCaseBuffer]
GO

CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBuffer]  
	@BrowseNbr int = 100, -- Should use f(NbrLoggedAgents)
	@ProjectId int = 0, -- Normally ignored
	@DialingMask int = 0xFF, -- Bit: NA,NA,NA,NA,NA,PV,NP,PR 
	@ClearBuffer bit = 1, -- 1 -> clear and fill; 0 -> append to buffer
	@GroupNbr int = 0 , -- Default 0, ignored for project Roles
	@RoleSets varchar(max) = null, -- '1,2,3;1,4;1,2,4' ',' -> seperates roles, ';' seperates roleset belonging to same group/agent
	@TraceInfo varchar(max) = null,
	@TraceId bigint = null OUT,
	@FilterEmptyPhone bit = 0,
	@PhoneAlias nvarchar(32) = '',
	@ManualFilter int = null -- (null (default), 0, 1)
AS
	--Disable tracing
	SET NOCOUNT ON

	-- version Sept 2013
	DECLARE @RequestedCases int, @ExcludedCases bigint, @HalfOpenExcess int, @TotalExtractedCases int
	SET @RequestedCases = @BrowseNbr;

	DECLARE @StartTStamp DateTime
	SET @StartTStamp = getutcdate();

	DECLARE @isPreviewSupported bit
	SET @isPreviewSupported = (@DialingMask & 0x4) --3rd bit from right says module does Preview dial

	--Get configuration information
	DECLARE @UseSmoothing bit
	SET @UseSmoothing= (SELECT TOP 1 INSVALUE FROM Installation WHERE INSSECTION='QUOTAS' and INSIDENT='QUOTASSMOOTH')
	IF (@UseSmoothing IS NULL) SET @UseSmoothing=0
	
	DECLARE @UseQuotas bit
	SET @UseQuotas = (SELECT TOP 1 INSVALUE FROM Installation  WHERE INSSECTION='QUOTAS' and INSIDENT='QUOTASACTIFS')
	IF (@UseQuotas is NULL) SET @UseQuotas = 0

	DECLARE @Replicate bit
	SET @Replicate = (SELECT TOP 1 coalesce(INSVALUE,0) From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTASMODEREPLICATE')
	IF (@Replicate is NULL) SET @Replicate = 0

	DECLARE @FreshPriority int
	SET @FreshPriority = (Select top 1 INSVALUE From Installation where INSSECTION='RULES' and INSIDENT='PRIORITY OF FRESH')
	IF (@FreshPriority IS NULL) SET @FreshPriority = 0
	
	-- Evaluate DNC options
	DECLARE @dncFlag int
	SET @dncFlag= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNC')
	IF (@dncFlag IS NULL) SET @dncFlag = 1
	DECLARE @dncExpirationPeriod int
	SET @dncExpirationPeriod= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNCRegistrationExpiringPeriod')
	IF (@dncExpirationPeriod IS NULL) SET @dncExpirationPeriod = 36 --Default 36 month if @dncFlag = 2 and ExpirationPeriod not found
	DECLARE @dncExpirationDate datetime;
	SET @dncExpirationDate = DATEADD (month , -@dncExpirationPeriod , GETUTCDATE() ) -- Pre calculate the DNC expiration date

	-- ### BufferTraceDetail: Evaluate  isBufferTraceDetailEnabled option
	DECLARE @isBufferTraceDetailEnabled int;
	SET @isBufferTraceDetailEnabled = ( SELECT TOP 1 insvalue FROM Installation WHERE INSSECTION = 'OPTIONS' 	AND INSIDENT = 'BufferTraceDetailEnabled' )
	IF (@isBufferTraceDetailEnabled IS NULL)   SET @isBufferTraceDetailEnabled = 0
	
	DECLARE @InsertedTrace table(TraceId bigint)
	INSERT INTO BufferTrace(Info,StartDate,EndDate,ApplicationName,ClientHostname,
		RequestedCases,DialingMask,ClearBuffer,GroupNbr,RoleSets,
		UseSmoothing,UseQuotas,[Replicate],DNCFlag,FreshPriority,WeightsCount,
		ExcludedCases,HalfOpenExcess,TotalExtractedCases,ManualFilter)
	OUTPUT inserted.TraceId INTO @InsertedTrace
	VALUES (@TraceInfo,@StartTStamp,0,APP_NAME(),HOST_NAME(),
		@RequestedCases,@DialingMask,@ClearBuffer,@GroupNbr,@RoleSets,
		@UseSmoothing,@UseQuotas,@Replicate,@dncFlag,@FreshPriority,0,
		0,0,0,@ManualFilter)
	SELECT @TraceId = TraceId FROM @InsertedTrace  

	-- This evaluation test the last time [VX_sp_ReassignHardCallback] was executed. If it makes more than 5 minutes, 
	--   we will trigger the execution.
	DECLARE @LastExecution DATETIME
	SET @LastExecution = (SELECT TOP 1 InsDateTimeValue FROM Installation WHERE INSSECTION='CALLBACKS' and INSIDENT='LAST_REASSIGNMENT_JOB_TIME')
	IF ( (@LastExecution IS NULL) OR ( @LastExecution < (DATEADD(MINUTE, -5, GETUTCDATE())) ) ) EXEC [dbo].[VX_sp_ReassignHardCallback] @TraceId = @TraceId;

	--Get Project mode (GROUP or ROLESET)
	DECLARE @useGroup bit
	SET @useGroup = (SELECT 0 FROM tblPages WHERE kind = 12000 and name = 'SAMPLEASSIGNMENTMODE' and StaticValue = 'ROLE'	and k_id = 
		(SELECT k_id FROM tblPages WHERE Kind = 12000 and Name = 'InterviewerProjectId' and ('Voxco_Project_' + StaticValue = DB_NAME())))
	IF (@useGroup IS NULL) SET @useGroup = 1

	-- ### BufferNewTemp: Create BufferNewTemp  - All sub store proc will filled that tmp table
	CREATE TABLE #BufferNewTemp (
		OrderKey				int			Identity (1,1)			NOT NULL,
		Respondent				varchar(10)							NOT NULL,
		intgroup				int									NULL,
		ResCall					bit			DEFAULT ((0))			NULL,
		NewDateTime				datetime	DEFAULT (getutcdate())	NULL,
		CallbackDate			datetime	DEFAULT ((-2))			NULL,
		[Priority]				int			DEFAULT ((1))			NULL,
		seed					float		DEFAULT (rand())		NULL,
		Phone					varchar(20)							NULL,
		projectId				int									NULL,
		DialingMode				int			DEFAULT ((0))			NOT NULL,
		Weighted				bit									NULL,
		Ranking					int									NULL ,
		Position				bigint								NULL,
		DeletedByHalfOpen		bit			DEFAULT ((0))			NOT NULL,
		FromPreviousBufferNew	bit			DEFAULT ((0))			NOT NULL
	PRIMARY KEY CLUSTERED ( Respondent ASC )
		WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY] 	) ON [PRIMARY]

	if ((@ClearBuffer = 1) and (@useGroup = 1))
	begin
		--Clear previous case buffer for group
		DELETE FROM dbo.BufferNew WHERE intgroup = @GroupNbr
	end
	else if (@ClearBuffer = 1)  -- and @useGroup = 0 (Role)
	begin
		--Clear all previous case buffer
		DELETE FROM dbo.BufferNew
	END

	--Compile TimeSlots hit by each TimeZones   
	CREATE TABLE #tzts (timezone int,timeslot int)
	INSERT INTO #tzts
	SELECT id+0 as timezone,dbo.TimeSlotNumber(DateAdd(mi,(gmtbias + dstbias*dstactive)*60,GetUTCDATE())) as timeslot
	FROM dbo.TimeZones
	UNION SELECT 0,dbo.TimeSlotNumber(GetUTCDate())

	--Compile list of invalid respondent (timeslot limit reached, closed stratum)
	CREATE TABLE #excludedRespondent(respondent varchar(10) primary key) -- List of respondent invalid (TimeSlot / Closed Quotas)

	INSERT INTO #excludedRespondent
	SELECT ResRespondent -- Add respondent that are hit by the current TimeSlot
	FROM Respondent with(nolock)
		inner join #tzts on #tzts.timezone = Respondent.ResTimeZone 
		inner join TimeSlot with(nolock) on TimeSlot.TslNumber = #tzts.TimeSlot
		left join TimeSlotHit with(nolock) on #tzts.timeslot = TimeSlotHit.TshTimeSlot and TimeSlotHit.TshRespondent = Respondent.ResRespondent
		left join TimeSlotCounter with(nolock) on TimeSlot.TslNumber = TimeSlotCounter.TslNumber and Respondent.IntLevel = TimeSlotCounter.RespondentLevel
	WHERE	(RestrictionOverride = 0) --Ignore exclusion in all cases where RestrictionOverride =1
			and (ResBlocked = 0)
			and (Respondent.Location = 'Server')
			and (ResActive = 1)
			and ((Respondent.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
			and (
					ResTimeSlot <> 0 
					and (
							TimeSlotCounter.MaxCounter = 0 
							or (TimeSlotCounter.MaxCounter is null and TimeSlot.MaxCounter = 0) 
							or (TimeSlotCounter.MaxCounter is null and TimeSlotHit.[Counter] >= TimeSlot.MaxCounter)
							or (TimeSlotHit.[Counter] >= TimeSlotCounter.MaxCounter)
						)
				) -- Only exlude respondent whose reached the max for the timeslot
	UNION -- UNION instead of UNION ALL for better performance filtering the Buffer New inserts
	SELECT StrRespondent -- Add respondent that are part of a closed quota
	FROM Stratum with(nolock)
		inner join Quota with(nolock) on QtStratum = StrStratum
		inner join Respondent with(nolock) on StrRespondent = ResRespondent
	WHERE QtStatusTemp = 2 /*Closed strata*/ and (ResBlocked = 0 and RestrictionOverride = 0) --Respondent that belong to closed strata but incorrectly blocked.
	UNION -- ### BufferTraceDetail: Populate #excludedRespondent with the BufferNew Left over
	SELECT Respondent FROM BufferNew where Respondent not in (select respondent from #excludedRespondent)


	-- We remove this because it can not be part of the feature exclude override
	--UNION
	--SELECT ResRespondent
	--FROM Respondent with(nolock) inner join DoNotCallList with(nolock) on Phone = ResPhone
	--WHERE (@dncFlag = 1 ) OR (@dncFlag = 2 AND RegistrationDate > @dncExpirationDate ) --Exclude DNC if active
	SET @ExcludedCases = @@RowCount --Number of excluded respondent (TimeSlot, Close Qt, already extracted)

	--ReEnable tracing
	--SET NOCOUNT OFF

	--Get stratum information
	DECLARE @NbrWeights int-- Number of Stratum with Weights
	SET @NbrWeights = 0
	if @Replicate <> 1 -- Weights and Replicates are not compatible : ignore the weights
		SELECT @NbrWeights = Count(QtStratum) FROM Quota with(nolock) 
		WHERE QtWeight >0 and QtStatusTemp<>2 AND QtUnused > 0 and (QtGroup=@GroupNbr or QtGroup=0)

	-- This is the sum of records to full fill all active stratum
	DECLARE @SumRemaining int
	SET @SumRemaining = 0
	-- This is a normalization to force the size of Rank 1 buket to 1000
	DECLARE @WeightNormalization float
	SET @WeightNormalization = 1 -- By default we do not use normalization

	if @UseSmoothing = 1
	begin
		SELECT @SumRemaining = SUM(case when (QtQuota - QtFrequence) > 0 then (QtQuota - QtFrequence) else 0 end) FROM Quota with(nolock)
		WHERE QtStratum <> 0 and (qtgroup=@GroupNbr or qtGroup=0) and QtWeight <> 0 and QtQuota > 0 and QtStatus < 2
		-- We only force  the normalization if the remaining records is over 2000
		if (@SumRemaining > 2000)
		begin
			-- The normalization is fixing the Rank 1 size to 1000
			set @WeightNormalization = cast(@SumRemaining as float)/cast(1000 as float)
		end
	end

	IF (@useGroup = 1)
	BEGIN --Group mode
	
		--Evaluate group string
		DECLARE @StrGroup char(3)
		SET @StrGroup = 'G' + right('0'+ convert(varchar(2),@groupnbr),2) --35% faster than with a if + length

		if @replicate = 0 
		begin
			if @UseSmoothing = 1 -- no replicates - smoothing (GROUP Mode)
			begin
				--##############################
				-- smoothing weight distribution
				--##############################
				EXEC VX_sp_FillCaseBufferGroupSmooth  @BrowseNbr, @ProjectId, @GroupNbr, @StrGroup, @UseQuotas, @dncFlag, @WeightNormalization, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @ManualFilter, @TotalExtractedCases OUT
			end
			else if @NbrWeights > 0 -- no replicates - weights (GROUP Mode)
			begin
				--##############################
				-- weight distribution
				--##############################
				EXEC VX_sp_FillCaseBufferGroupWeight @BrowseNbr, @ProjectId, @GroupNbr, @StrGroup, @UseQuotas, @dncFlag, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @ManualFilter, @TotalExtractedCases OUT
			end
			else
			begin
				--##############################
				-- general : no weights - no replicates - no smoothing (GROUP Mode)
				--##############################
				EXEC VX_sp_FillCaseBufferGroup @BrowseNbr, @ProjectId, @GroupNbr, @StrGroup, @UseQuotas, @dncFlag, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @ManualFilter, @TotalExtractedCases OUT
			end
		end
		else --if @replicate = 1
		begin
			--##############################
			-- 1: call-backs with high priority - regardless of statustemp
			--##############################
			--##############################
			-- 2: fresh cases -- one at a time for replicates with statustemp <> 2
			--##############################
			--##############################
			-- 3 : call-backs with low priority - regardless of statusTemp
			--##############################
			EXEC VX_sp_FillCaseBufferGroupReplicate @BrowseNbr, @ProjectId, @GroupNbr, @StrGroup, @UseQuotas, @dncFlag, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @FreshPriority, @ManualFilter, @TotalExtractedCases OUT
		end

	END ELSE BEGIN --Role mode

		-- Split supported roles
		SELECT RoleSet.Value RoleSet, convert(int, [Role].Value) [Role]
		INTO #SupportedRole
		FROM fn_cte_splitstring(@RoleSets, ';') RoleSet
			cross apply fn_cte_splitstring(RoleSet.Value, ',') [Role]
	
		if @replicate = 0 
		begin
			if @UseSmoothing = 1 -- no replicates - smoothing (ROLE Mode)
			begin
				--##############################
				-- smoothing weight distribution
				--##############################
				EXEC VX_sp_FillCaseBufferRoleSmooth  @BrowseNbr, @ProjectId, @UseQuotas, @dncFlag, @WeightNormalization, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @ManualFilter, @TotalExtractedCases OUT
			end
			else if @NbrWeights > 0 -- -- no replicates - weights (ROLE Mode)
			begin
				--##############################
				-- weight distribution
				--##############################
				EXEC VX_sp_FillCaseBufferRoleWeight @BrowseNbr, @ProjectId, @UseQuotas, @dncFlag, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @ManualFilter, @TotalExtractedCases OUT
			end
			else
			begin
				--##############################
				-- general : no weights - no replicates - no smoothing (ROLE mode)
				--##############################
				EXEC VX_sp_FillCaseBufferRole @BrowseNbr, @ProjectId, @UseQuotas, @dncFlag, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @ManualFilter, @TotalExtractedCases OUT
			end
		end
		else --if @replicate = 1
		begin
			--##############################
			-- 1: call-backs with high priority - regardless of statustemp
			--##############################
			--##############################
			-- 2 : fresh cases -- one at a time for replicates with statustemp <> 2
			--##############################
			--##############################
			-- 3 : call-backs with low priority - regardless of statusTemp
			--##############################
			EXEC VX_sp_FillCaseBufferRoleReplicate @BrowseNbr, @ProjectId, @UseQuotas, @dncFlag, @isPreviewSupported, @dncExpirationDate, @FilterEmptyPhone, @PhoneAlias, @FreshPriority, @ManualFilter, @TotalExtractedCases OUT
		end

		DROP TABLE #SupportedRole
	END

	--Verify HalfOpen stratum
	SET @HalfOpenExcess = 0
	IF @Replicate <> 1 --HalfOpen not supported with Replicate
	BEGIN
		DECLARE @HOStratum int --Count of halfopen stratum
		DECLARE @IncrementStratum int --Count of stratum with increment question defined
		SELECT @HOStratum = SUM(case when QtStatus = 1 then 1 else 0 end),
			@IncrementStratum = SUM(case when IncrementQuestion <> '' then 1 else 0 end)
		FROM QUOTA with(nolock) WHERE ( QtGroup=0 or QtGroup=0) and QtQuota>0

		IF @HOStratum > 0 --HalfOpen stratum exists
		BEGIN
			IF @IncrementStratum = 0 --No stratum uses a IncrementQuestion setting
			BEGIN -- Update Respondent that exceeds HalfOpen Quotas using optimal window row_number function
				UPDATE  #BufferNewTemp SET DeletedByHalfOpen = 1
				WHERE EXISTS (
					SELECT Respondent
					FROM
					(SELECT Respondent Respondent,
						row_number() over (partition by QtQuotaId order by priority, callbackdate, seed) [rank],
						Qt.QtQuota - (QtFrequence + QtOnline) [max]
					FROM #BufferNewTemp 
						inner join Stratum with(nolock) on Respondent = StrRespondent
						inner join Quota Qt with(nolock) on StrQuotaId = Qt.QtQuotaId
					WHERE IntGroup = @GroupNbr and Qt.QtStatus = 1 and Qt.QtQuota>0) res
					WHERE [rank] > [max] and res.respondent = #BufferNewTemp.Respondent
				)
			END ELSE --At least one stratum with IncrementQuestion setting
			BEGIN -- Delete Respondent that exceeds HalfOpen Quotas using running sum evaluation
				-- Build a runningSum CTE
				WITH runningSum AS
				(
				SELECT Respondent Respondent, QuotaId, [max], [rank], IncrementValue RunningSum, 0 PreviousRunningSum
				FROM
					(SELECT Respondent Respondent, StrQuotaId QuotaId, 
						QtQuota - (QtFrequence + QtOnline) [max],
						row_number() over (partition by StrQuotaId order by priority, callbackdate, seed) [rank], IncrementValue
					 FROM #BufferNewTemp inner join Stratum with(nolock) inner join Quota with(nolock) on QtQuotaId = StrQuotaId on Respondent = StrRespondent 
					 WHERE IntGroup = 0 and QtStatus = 1 and QtQuota >0) a
				WHERE [rank] = 1 UNION ALL
				SELECT a.Respondent Respondent, a.QuotaId, runningSum.[max], a.[rank], (runningSum.RunningSum + a.IncrementValue) RunningSum, runningSum.RunningSum PreviousRunningSum
				FROM
					runningSum inner join 
					(SELECT Respondent Respondent, StrQuotaId QuotaId, 
						row_number() over (partition by StrQuotaId order by priority, callbackdate, seed) [rank], IncrementValue
					 FROM #BufferNewTemp inner join Stratum with(nolock) on Respondent = StrRespondent 
					 ) a on runningSum.QuotaId = a.QuotaId and runningSum.[rank]+1 = a.[rank]
				)

				-- Use the CTE to delete any cases that follow the case that would cause the stratum to close
				UPDATE  #BufferNewTemp SET DeletedByHalfOpen = 1
				WHERE EXISTS (SELECT Respondent FROM runningSum WHERE PreviousRunningSum >= [max] and Respondent = #BufferNewTemp.Respondent)
				OPTION (MAXRECURSION 20000); --Default recursion limit incremented from default 100 to 10x the maximum we would expect
			END

			SET @HalfOpenExcess = @@RowCount
			SET @TotalExtractedCases = @TotalExtractedCases - @HalfOpenExcess
		END
	END

	DROP TABLE #tzts
	DROP TABLE #excludedRespondent

	-- Write Buffernew  with tempbuffernew
	INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
	SELECT  Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode  FROM #BufferNewTemp WHERE DeletedByHalfOpen = 0 AND FromPreviousBufferNew = 0  ORDER BY  OrderKey 

	--Write a trace of the extraction
	SET NOCOUNT ON

	UPDATE BufferTrace SET EndDate = GETUTCDATE()
						, WeightsCount = @NbrWeights
						, ExcludedCases = @ExcludedCases
						, HalfOpenExcess = @HalfOpenExcess
						, TotalExtractedCases = @TotalExtractedCases
	WHERE BufferTrace.TraceId = @TraceId

	-- write BufferTraceDetail if needed
 IF ( @isBufferTraceDetailEnabled = 1 )
 BEGIN
	INSERT INTO BufferTraceDetail ( 	TraceId, OrderKey, Respondent 	,intgroup 	,CallbackDate 	,[Priority] 	,seed 	,Phone 	,ProjectId 	,DialingMode, Weighted, Ranking, Position, DeletedByHalfOpen,  FromPreviousBufferNew) 	
	SELECT 	@TraceId as TraceId, OrderKey, Respondent 	,intgroup 	,CallbackDate 	,[Priority] 	,seed 	,Phone 	,ProjectId 	,DialingMode, Weighted, Ranking, Position, DeletedByHalfOpen, FromPreviousBufferNew FROM #BufferNewTemp
 END
	SET NOCOUNT OFF
 
	DROP TABLE #BufferNewTemp

GO
